﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Mouse {
    public partial class Form1 : Form {
        public Form1() {
            InitializeComponent();
            
            this.timer1.Interval = 300;
            this.timer1.Enabled = true;
        }

        private void button1_Click(object sender, EventArgs e) {
            int iCurX, iCurY;
            int iLen;
            int iTarX, iTarY;
            double dIx, dIy;

            if(this.textBox1.Text == "") return;

            string [] sPos = this.textBox1.Text.Split(',');
            if(sPos.Length != 2) return;

            iTarX = Convert.ToInt32(sPos[0]);
            iTarY = Convert.ToInt32(sPos[1]);

            // マウス位置取得
            iCurX = System.Windows.Forms.Cursor.Position.X;
            iCurY = System.Windows.Forms.Cursor.Position.Y;

            // 目的位置までの移動量
            if(Math.Abs(iTarX - iCurX) > Math.Abs(iTarY - iCurY)){
                iLen = iTarX - iCurX;
                dIx = iLen / Math.Abs(iLen);
                dIy = (double)(iTarY - iCurY) / (double)Math.Abs(iTarX - iCurX);
            } else {
                iLen = iTarY - iCurY;
                dIx = (double)(iTarX - iCurX) / (double)Math.Abs(iTarY - iCurY);
                dIy = iLen / Math.Abs(iLen);
            }
            
            // マウス移動
            for(int iLop = 0; iLop < Math.Abs(iLen); iLop++){
                System.Windows.Forms.Cursor.Position = new System.Drawing.Point(iCurX + (int)((double)iLop * dIx), iCurY + (int)((double)iLop * dIy));
                System.Threading.Thread.Sleep(10);
            }
            // 最終的に目的位置に設定
            System.Windows.Forms.Cursor.Position = new System.Drawing.Point(iTarX, iTarY);


        }

        private void timer1_Tick(object sender, EventArgs e) {
            // マウス位置取得
            this.toolStripStatusLabel1.Text = Cursor.Position.X.ToString() + "," + Cursor.Position.Y.ToString();
        }
    }
}
