﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace Mouse {
    public partial class Form1 : Form {
        /// <summary>
        /// マウス操作のためのAPI
        /// </summary>
        /// <param name="dwFlags"></param>
        /// <param name="dx"></param>
        /// <param name="dy"></param>
        /// <param name="cButtons"></param>
        /// <param name="dwExtraInfo"></param>
        [DllImport("USER32.dll", CallingConvention = CallingConvention.StdCall)]
        static extern void mouse_event(int dwFlags, int dx, int dy, int cButtons, int dwExtraInfo);
        private const int MOUSEEVENTF_LEFTDOWN = 0x2;
        private const int MOUSEEVENTF_LEFTUP = 0x4;
        private const int MOUSEEVENTF_RIGHTDOWN = 0x8;
        private const int MOUSEEVENTF_RIGHTUP = 0x10;
        private const int MOUSEEVENTF_MIDDLEDOWN = 0x20;
        private const int MOUSEEVENTF_MIDDLEUP = 0x40;

        public Form1() {
            InitializeComponent();
            
            this.timer1.Interval = 300;
            this.timer1.Enabled = true;
        }

        private void button1_Click(object sender, EventArgs e) {
            int iCurX, iCurY;
            int iLen;
            int iTarX, iTarY;
            double dIx, dIy;

            if(this.textBox1.Text == "") return;

            string [] sPos = this.textBox1.Text.Split(',');
            if(sPos.Length != 2) return;

            iTarX = Convert.ToInt32(sPos[0]);
            iTarY = Convert.ToInt32(sPos[1]);

            // マウス位置取得
            iCurX = System.Windows.Forms.Cursor.Position.X;
            iCurY = System.Windows.Forms.Cursor.Position.Y;

            // 目的位置までの移動量
            if(Math.Abs(iTarX - iCurX) > Math.Abs(iTarY - iCurY)){
                iLen = iTarX - iCurX;
                dIx = iLen / Math.Abs(iLen);
                dIy = (double)(iTarY - iCurY) / (double)Math.Abs(iTarX - iCurX);
            } else {
                iLen = iTarY - iCurY;
                dIx = (double)(iTarX - iCurX) / (double)Math.Abs(iTarY - iCurY);
                dIy = iLen / Math.Abs(iLen);
            }
            
            // マウス移動
            for(int iLop = 0; iLop < Math.Abs(iLen); iLop++){
                System.Windows.Forms.Cursor.Position = new System.Drawing.Point(iCurX + (int)((double)iLop * dIx), iCurY + (int)((double)iLop * dIy));
                System.Threading.Thread.Sleep(10);
            }
            // 最終的に目的位置に設定
            System.Windows.Forms.Cursor.Position = new System.Drawing.Point(iTarX, iTarY);

        // マウスクリック
        mouse_event(MOUSEEVENTF_LEFTDOWN, 0, 0, 0, 0);
        System.Threading.Thread.Sleep(300);
        mouse_event(MOUSEEVENTF_LEFTUP, 0, 0, 0, 0);

        }

        private void timer1_Tick(object sender, EventArgs e) {
            // マウス位置取得
            this.toolStripStatusLabel1.Text = Cursor.Position.X.ToString() + "," + Cursor.Position.Y.ToString();
        }
    }
}
