﻿using System;
using System.Windows.Forms;

namespace WindowsFormsApp1 {
    public partial class Form1 : Form {
        public Form1() {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e) {
            // DLLファイルが存在するか確認する
            if(System.IO.File.Exists(this.textBox1.Text) == false){
                MessageBox.Show("DLLファイルが見つからない。");
                return;
            }

            // DLLファイルをアセンブリに読み込み
            System.Reflection.Assembly asm = System.Reflection.Assembly.LoadFrom(this.textBox1.Text);
            // モジュールを取得
            System.Reflection.Module mod = asm.GetModule(System.IO.Path.GetFileName(this.textBox1.Text));
            Type ty = mod.GetType("ClassLibrary1.Class1");

            // メソッドの引数情報を取得
            System.Reflection.MethodInfo mi = ty.GetMethod("Sample");
            System.Reflection.ParameterInfo [] pi = mi.GetParameters();

			if(ty != null) {
                // 引数用のパラメータ作成 (パラメータの数だけ）
    			Type[] types = new Type[]{pi[0].ParameterType};
                // MethodInfoオブジェクトの取得
				System.Reflection.MethodInfo method = ty.GetMethod("Sample", types); // DLLのメソッド'Sample'
                // オブジェクト生成
                object obj = System.Activator.CreateInstance(ty);

                // 引数を設定
                object [] Param = new object[]{"World!"};  // 引数'World!'
				// DLL実行 （デリゲート呼び出し）
                var Res = method.Invoke(obj, Param); 
                // 結果の表示
                MessageBox.Show((string)Res);
            }
        }

        private void button2_Click(object sender, EventArgs e) {
            this.openFileDialog1.Filter = "DLLファイル|*.DLL";
            if(this.openFileDialog1.ShowDialog() == DialogResult.OK){
                this.textBox1.Text = this.openFileDialog1.FileName;    
            }
        }

    }
}
